## Host Resource In App

we may need to host some resource in app, such as a file, a 3d model, etc. currently following components need you host resource:

* Resource Loaders in 3D (three.GLTFLoader, etc) to load model from path

* File Download (mui.Link)


### File Download

```Python
from tensorpc.flow import mui, three, plus, appctx, mark_create_layout, mark_did_mount, mark_will_unmount
from pathlib import Path 
sample_code = """
print("hello world!")
"""
class App:
    @mark_create_layout
    def my_layout(self):
        self.inp = mui.Input("Custom File Name", init="custom.py")
        return mui.VBox([
            mui.Link.safe_download_link("click to download", "tensorpc://sample.py"),
            mui.Link.safe_download_link("click to download from path", "tensorpc://tensorpc_source_code"),
            self.inp,
            mui.Link.safe_download_link("click to download with custom name", "tensorpc://custom_file_name"),
        ])

    @mark_did_mount
    def _on_mount(self):
        # WARNING this add handler to global app, not "App" in this tutorial
        appctx.get_app().add_file_resource("sample.py", self.sample_file)
        appctx.get_app().add_file_resource("custom_file_name", self.sample_file_custom_name)
        appctx.get_app().add_file_resource("tensorpc_source_code", self.sample_file_from_path)

    @mark_will_unmount
    def _on_unmount(self):
        appctx.get_app().remove_file_resource("sample.py")
        appctx.get_app().remove_file_resource("custom_file_name")
        appctx.get_app().remove_file_resource("tensorpc_source_code")

    def sample_file(self):
        # file handler must return str, bytes or mui.FileResource which 
        # can contains str, bytes or a real path.
        # if you return str, it will be encoded with utf-8.
        return sample_code

    def sample_file_from_path(self):
        # use mui.FileResource to specify a path
        path = Path(mui.__file__).resolve()
        return mui.FileResource(name=path.name, path=str(path))

    def sample_file_custom_name(self):
        # use mui.FileResource to specify custom filename
        return mui.FileResource(name=self.inp.str(), content=sample_code.encode())

```

### Resource Loaders

TODO